/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.blocks;

import com.mojang.serialization.MapCodec;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.util.MathHelpers;

public class ChuteBlock
extends class_2383
implements class_2343 {
    private static final Map<class_2350, class_265> SHAPES = new HashMap<class_2350, class_265>();

    private class_265 createShapeForDirection(class_2350 direction) {
        return class_259.method_1084((class_265)MathHelpers.rotateVoxelShape(class_259.method_1081((double)0.125, (double)0.25, (double)0.875, (double)0.875, (double)1.0, (double)1.0), direction, class_2738.field_12475), (class_265)MathHelpers.rotateVoxelShape(class_259.method_1081((double)0.1875, (double)0.3125, (double)1.0, (double)0.8125, (double)0.9375, (double)1.125), direction, class_2738.field_12475)).method_1097();
    }

    public ChuteBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Optional candidate = world.method_35230(pos, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (candidate.isPresent()) {
            ChuteBlockEntity entity = (ChuteBlockEntity)((Object)candidate.get());
            if (!entity.isUsed()) {
                return super.method_55765(stack, state, world, pos, player, hand, hit);
            }
            if (!world.field_9236) {
                entity.assignFilterItem(stack, player);
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        Optional candidate = world.method_35230(pos, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (candidate.isPresent()) {
            ChuteBlockEntity entity = (ChuteBlockEntity)((Object)candidate.get());
            if (!entity.isUsed()) {
                return super.method_55766(state, world, pos, player, hit);
            }
            if (!world.field_9236) {
                entity.resetFilterItem(player);
            }
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return SHAPES.computeIfAbsent(dir, this::createShapeForDirection);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 targetFacing = ctx.method_8038();
        if (targetFacing.method_10166().method_10178()) {
            targetFacing = ctx.method_8042().method_10153();
        }
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)class_2741.field_12481, (Comparable)targetFacing);
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ChuteBlockEntity(pos, state);
    }

    protected boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        super.method_9592(state, world, pos, type, data);
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(type, data);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ChuteBlockEntity) {
                ChuteBlockEntity chuteBlockEntity = (ChuteBlockEntity)blockEntity;
                chuteBlockEntity.tick(world1, pos, state1, chuteBlockEntity);
            }
        };
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world.field_9236) {
            return super.method_9576(world, pos, state, player);
        }
        Optional chuteEntity = world.method_35230(pos, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (chuteEntity.isEmpty()) {
            return super.method_9576(world, pos, state, player);
        }
        ((ChuteBlockEntity)((Object)chuteEntity.get())).dropContent(world, pos);
        return super.method_9576(world, pos, state, player);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        boolean showExtra = class_437.method_25441();
        if (showExtra) {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.belts.chute.tooltip.1").method_27692(class_124.field_1080));
            if (Platform.isModLoaded((String)"ftbfiltersystem")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"block.belts.chute.tooltip.ftbfilters").method_27692(class_124.field_1080));
            }
        }
        super.method_9568(stack, context, tooltip, options);
    }
}

